﻿//check_ip.js  added by lixuzhen for check ip

function check_ip_format(s)   
{   
	var patrn=/^\d{1,3}.\d{1,3}.\d{1,3}.\d{1,3}$/;   
	if (!patrn.exec(s)) return false;
	
	var ip_arr = s.split('.');
	for(var i =0 ; i < 4; i++)
	{
		if((parseInt(ip_arr[i]) < 0) || (parseInt(ip_arr[i]) > 255))
		{
			return false;
		}
	}
	return true;
} 

/* return 0: means ip format error;
          1: means CLASS A ip address
		  2: means CLASS B ip address
		  3: means CLASS C ip address
		  4: means CLASS D ip address
		  5: means CLASS E ip address
*/
function find_network_type(s)
{
	if(!check_ip_format(s))
	{
		return 0;
	}
	
	var ip_arr = s.split('.');
	var result;
	//CLASS A:0~127;     CLASS B: 128~191;   CLASS C:192~223;   CLASS D:224~239;   CLASS E:240~247
	//0xxxxxxx CLASS A
	result = ip_arr[0]>>7;
	if(0 == result)
	{
		return 1;
	}
	//10xxxxxx CLASS B
	result = ip_arr[0]>>6;
	if(2 == result)
	{
		return 2;
	}
	//110xxxxx CLASS C
	result = ip_arr[0]>>5;
	if(6 == result)
	{
		return 3;
	}
	//1110xxxx CLASS D
	result = ip_arr[0]>>4;
	if(14 == result)
	{
		return 4;
	}
	//11110xxx
	result = ip_arr[0]>>3;
	if(30 == result)
	{
		return 5;
	}
	return 0;
}

/* check netmask arr, it can be 00000000,
								10000000,
								11000000,
								11100000,
								11110000,
								11111000,
								11111100,
								11111110,
								11111111
*/
function check_netmask_arr(s)
{
	for(var i = 0; i <= 8; i++)
	{
		if(s == 255-(Math.pow(2,i)-1))
		{
			return true;
		}
	}
	return false;
}

/* ip_type: 1, means CLASS A ip address
            2, means CLASS B ip address
			3, means CLASS C ip address
*/
function check_netmask(ip_type, netmask)
{
	if((ip_type < 1) || (ip_type > 3))
	{
		return false;
	}
	if(!check_ip_format(netmask))
	{
		return false;
	}
	var netmask_arr = netmask.split('.');
	var count_255 = 0;
	var stop_255 = 0;
	for(var i = 0; i < 4; i++)
	{
		if(255 == netmask_arr[i])
		{
			if(1 == stop_255)
			{
				return false;
			}
			count_255++;
			continue;
		}
		else if(check_netmask_arr(netmask_arr[i]))
		{
			if((1 == stop_255) && (0 != netmask_arr[i]))
			{
				return false;
			}
			stop_255 = 1;
		}
		else
		{
			return false;
		}
	}
	if((count_255 < ip_type) || (count_255 == 4))
	{
		return false;
	}
	return true;
}

/* net_mask: net work mask
   ip_addr:  ip address
   get_net_id:  0, get host id
                1, get net id
*/
function compute_net_or_host_id(net_mask, ip_addr, get_net_id)
{
	var ip_class = find_network_type(ip_addr);
	if((ip_class < 1) || (ip_class > 4))
	{
		return 0;
	}
	
	if(!check_netmask(ip_class, net_mask))
	{
		return 0;
	}
	
	var net_mask_arr = net_mask.split('.');
	var ip_addr_arr = ip_addr.split('.');
	var net_id = new Array();
	for (var i=0; i<4; i++)
	{
		if(get_net_id)
		{
			net_id[i] = net_mask_arr[i] & ip_addr_arr[i];
		}
		else
		{
			net_id[i] = (~net_mask_arr[i]) & ip_addr_arr[i];
		}
	}
	return net_id[0]+'.'+net_id[1]+'.'+net_id[2]+'.'+net_id[3];
}

/* return -1: means the net id of two ip is different, can't compare.
           0: means two ip is the same
		   1: means left_host is bigger than right _host
		   2: means right_host is bigger than left_hsot
*/
function compare_host_id(left_host, right_host, net_mask)
{
	if(compute_net_or_host_id(net_mask, left_host, 1) != compute_net_or_host_id(net_mask, right_host, 1))
	{
		return -1;
	}
	var left_host_id = compute_net_or_host_id(net_mask, left_host, 0);
	var right_host_id = compute_net_or_host_id(net_mask, right_host, 0);
	var left_shot_arr = left_host_id.split('.');
	var right_host_arr = right_host_id.split('.');
	for(var i=0; i<4; i++)
	{
		if(parseInt(left_shot_arr[i])>parseInt(right_host_arr[i]))
		{
			return 1;
		}
		else if(parseInt(left_shot_arr[i])<parseInt(right_host_arr[i]))
		{
			return 2;
		}
	}
	return 0;
}